/*
 * CalendarClient.java
 *
 * Created on November 9, 2004, 10:38 AM
 */
package dop;

import java.util.*;
import java.text.*;
import java.io.*;
import java.rmi.*;
import java.rmi.server.*;

/**
 *
 * @author  garbi
 */
public class CalendarClient extends UnicastRemoteObject implements CalendarListener {

    static private DateFormat dform = DateFormat.getDateInstance(DateFormat.MEDIUM, Locale.US);

    public CalendarClient() throws RemoteException {
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        String hostname = "localhost";
        String rmiport = "1099";
        System.out.println("**************************************************************************************");
        if (args.length > 0) {
            hostname = args[0];
        } else {
            System.out.println("As no hostname provided in the command line, the \"localhost\" is used to create the server name ");//this is what acttualy happens!
        }

        try {
            String wtcName = "World Trade Center";
            String cccName = "Convention Conference Center";
            String calServName = "//" + hostname+":"+rmiport+ "/Calendar"; // server name in URL format

            CalendarService calServ = (CalendarService) Naming.lookup(calServName);

            if (!calServ.exists(wtcName)) {
                
                calServ.createCalendar(wtcName);//A DayCalendar object with wtcName is created and added to the hash map of CalendarServer
            }
            if (!calServ.exists(cccName)) {
                
                calServ.createCalendar(cccName);//A DayCalendar object with cccName is created and added to the hash map of CalendarServer
            }

            // Test what the server can do
            Collection allCals = calServ.getCalendars();
            System.out.print("Known calendars : ");
            Iterator iter = allCals.iterator();// allCals and iter remotely refrence the DayCalendar objects created above
            while (iter.hasNext()) {
                DayCalendar dayCal = (DayCalendar) iter.next();
                System.out.print("\"" + dayCal.getName() + "\" ");
            }
            System.out.println("\n");

            //Remove one object from CalendarServer hash map
            /*calServ.removeCalendar(cccName);//the DayCalendar object with cccName is removed from the CalendarServer hash map but it is still remotely refrenced by allCals and iter!
            System.out.println("\"Convention Conference Center\" is removed from server calendars!");
            allCals = null;
            iter = null;
            //By assigining allCals and iter to null, both DayCalendar objects are no longer remotely refrenced!
            System.gc();*/

            // Test what calendars can do
            DayCalendar wtc = calServ.getCalendar(wtcName);
            BufferedReader kbdIn = new BufferedReader(new InputStreamReader(System.in));
            String fromUser;
            DayEvent event;
            String what, when;


            // Register calendar listener
            CalendarListener calist = new CalendarClient();
            wtc.addListener(calist);

            System.out.println("**************************************************************************************");
            System.out.println("Please enter a new event (type \"quit\" to stop) in the "+wtc.getName()+" calendar");
            while (true) {
                System.out.println("What(event name): ");
                what = kbdIn.readLine();
                if (what.trim().toLowerCase().equals("quit")) {
                    System.exit(0);
                }

                Date date;
                while (true) {
                    if ((date = askForDate(kbdIn)) == null) {
                        System.out.print("You must start all over again!");
                        break;
                    }
                    if (wtc.isFree(date)) {
                        break;
                    } else {
                        System.out.println(dform.format(date) + " is not a free date, try another one!");
                    }
                }

                if (date != null) {
                    event = new DayEvent(date, what);
                    wtc.plan(event);
                }
                listEvents(wtc);

                // test the getEventForDate method
                //if (wtc.getEventForDate(new Date("Jan 12, 2009")) != null) {
                   // System.out.println("OK");
               // } else {
                   // System.out.println("Rien");
                //}
            }



        } catch (Exception e) {
            System.out.println("Problem: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /**
     * @param wtc
     * @throws RemoteException
     */
    private static void listEvents(final DayCalendar wtc) throws RemoteException {
        String[] elist = wtc.listEvents();
        System.out.println("\n---\nFull day events for \"" + wtc.getName() + "\":");
        for (int i = 0; i < elist.length; i++) {
            System.out.println("  - " + elist[i]);// call DayEvent() toString().
        }
        System.out.println("\n---\n");
    }

    private static Date askForDate(final BufferedReader kbdIn)
            throws IOException {//this method, prompt the user to provide the date.

        String when;
        int attempts = 3;
        Date date = null;
        while (true) {
            try {
                System.out.println("When: ");
                when = kbdIn.readLine();
                if (when.trim().toLowerCase().equals("quit")) {
                    System.exit(0);// if user enters "quit" the program exits.
                }
                date = dform.parse(when);// parse the input to the format defined by DateFormat class
                break;//exits from the current loop.
            } catch (ParseException e) {
                System.out.print("oups, wrong date format; date format should be (Month day, year) for example (July 15, 2011)");
                if (attempts == 0) {
                    System.out.println(", no more attempts!");
                    break;
                }
                System.out.println(", try again!");
                attempts--;
            }
        }

        return date;
    }

    public void eventPlanned(DayEvent e) throws RemoteException {
        System.out.println("--> New event planned: " + e);
    }
}
